<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CLanguages extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
		$this->name = "languages";

		$this->tpl_module = array(
			"module_name"	=> "Languages",
			"module_code"	=> $this->name
		);

	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == $this->name) {

			$sub = $_GET["sub"];
			$action = $_GET["action"];
		
			//$lang = $this->DefaultLang();
			//$_GET["lang_id"] = $lang["lang_id"];

			switch ($sub) {
				case "landing":
					$sub = "languages";
				case "languages":					
					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);
					$this->PrepareFields($data->forms["forms"]);
					$this->PrepareFieldsLocale($data->forms["forms"]);
					$data->functions = array( 
							"onstore_prepare" => array(&$this , "StoreLanguage"),
							"ondelete"	=> array(&$this , "DeleteLanguage"),
					);					

					return $data->DoEvents();
				break;

				case "settings":
		
					$data = new CFormSettings($this->forms_path  . $sub . ".xml" ,$_CONF["forms"]["admintemplate"] , $this->db,$this->tables);

					$this->PrepareDashboard($data->form);
					$this->LangPrepareFields($data->form);

					if ($data->Done()) {
						$this->vars->SetVars(
							$this->vars->ExtractVals(
								CForm::KeyFields($data->form),
								$_POST
							)
						);
					}
					
					return $data->Show(
						$this->vars->GetVars(
							CForm::KeyFields($data->form)
						)
					);
				break;


			}
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function UpdateVars() {
		global $_AJAX , $base;

			//debug($_POST,1);

		if (is_array($_POST["lang_var"])) {



			foreach ($_POST["lang_var"] as $key => $val) {

				$tmp = array();

				foreach ($val as $k => $v) {
					$tmp["lang_val_{$k}"] = $v;
				}


				
				$this->db->QueryUpdate(
					$this->tables['core:languages_vars'],
					$tmp , 
					"lang_var LIKE '{$key}'"
				);

			}			
		}

		if ($_AJAX) {

			return $base->htmlElements->AlertSmall(
				"neutral",
				"Autosaved..."
			);
		}
	

		if ($_GET["returnurl"]) {
			urlredirect(urldecode($_GET["returnurl"]));
		} else {
			urlredirect("index.php?mod=languages&sub=vars");
		}
		
		
	}
	

	function DefaultLang($noupdate = false) {
		global $_LANG_ID , $_LANG_CODE , $_LANG_RAW;

		if (isModSub("languages" , "landing"))  {
			return "";
		}
		

		$lang = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:languages']} WHERE lang_default=1 LIMIT 1");

		if (!$_GET["lang_id"]) {
			$_GET["lang_id"] = $lang["lang_id"];
		}

		if (!$_LANG_ID) {
			$_LANG_ID = $_GET["lang_id"];
		}

		if (!$_LANG_RAW) {
			$_LANG_RAW = $lang;
		}

		if (!$_LANG_CODE) {
			$_LANG_CODE = $lang["lang_code"];
		}

		if ($lang["lang_locale_date"]) {
			setlocale(LC_ALL , $lang["lang_locale_date"] . ".utf8" );
		}
						
		return $lang;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetLanguages() {

		return $this->db->QFetchRowArray("SELECT * FROM {$this->tables['core:languages']} ");

	}

	
	function StoreLanguage($record) {

		if ($record["lang_id"]) {

			//get the language original record

			$old = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:languages']} WHERE lang_id={$record[lang_id]}");

			if ($old["lang_code"] == $this->vars->data["set_language"]) {
				$this->vars->setVars(array("set_language" => $record["lang_code"]));
			}
			
		}		
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DeleteLanguage($record) {

		if ($record["lang_code"] == $this->vars->data["set_language"]) {

			$new = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:languages']} WHERE lang_default=1");

			if (is_array($new)) {
				$this->vars->setVars(array("set_language" => $new["lang_code"]));
			}			

		}
		
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PrepareFieldsLocale(&$forms) {

		if (class_exists("ResourceBundle")) {
			$locals = ResourceBundle::getLocales("");

			foreach ($locals as $key => $val) {
				$forms["add"]["fields"]["box"][1]["fields"]["lang_locale_date"]["options"][$val] = $val;
				$forms["edit"]["fields"]["box"][1]["fields"]["lang_locale_date"]["options"][$val] = $val;
				$forms["details"]["fields"]["box"][1]["fields"]["lang_locale_date"]["options"][$val] = $val;
			}

		} else {

		}	
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function getLanguageById($id) {
		return $this->db->QFetchArray("SELECT * FROM {$this->tables['core:languages']} WHERE lang_id=%d" , array($id));

	}
	
	
}

?>